


     subroutine back2cell(nat,rxyz,alat)
!   folds back atoms into the simulation cell
     implicit real*8 (a-h,o-z)
     dimension rxyz(3,nat),xyzred(3,nat),alat(3,3)

        call cart2frac(nat,alat,rxyz,xyzred)
        do iat=1,nat
        do l=1,3
        xyzred(l,iat)=modulo(xyzred(l,iat),1.d0)
        enddo
        enddo
        call frac2cart(nat,alat,xyzred,rxyz)

     end subroutine   




subroutine cart2frac(nat,alat,rxyz,rxyzred)
  !This subroutine converts Cartesian into reduced coordinates
  implicit real*8 (a-h,o-z)
  dimension rxyzred(3,nat),rxyz(3,nat),alat(3,3),alatinv(3,3)

    div=(alat(1,1)*alat(2,2)*alat(3,3)-alat(1,1)*alat(2,3)*alat(3,2)- & 
         alat(1,2)*alat(2,1)*alat(3,3)+alat(1,2)*alat(2,3)*alat(3,1)+ & 
         alat(1,3)*alat(2,1)*alat(3,2)-alat(1,3)*alat(2,2)*alat(3,1))
    div=1.d0/div
      alatinv(1,1) = (alat(2,2)*alat(3,3)-alat(2,3)*alat(3,2))*div
      alatinv(1,2) =-(alat(1,2)*alat(3,3)-alat(1,3)*alat(3,2))*div
      alatinv(1,3) = (alat(1,2)*alat(2,3)-alat(1,3)*alat(2,2))*div
      alatinv(2,1) =-(alat(2,1)*alat(3,3)-alat(2,3)*alat(3,1))*div
      alatinv(2,2) = (alat(1,1)*alat(3,3)-alat(1,3)*alat(3,1))*div
      alatinv(2,3) =-(alat(1,1)*alat(2,3)-alat(1,3)*alat(2,1))*div
      alatinv(3,1) = (alat(2,1)*alat(3,2)-alat(2,2)*alat(3,1))*div
      alatinv(3,2) =-(alat(1,1)*alat(3,2)-alat(1,2)*alat(3,1))*div
      alatinv(3,3) = (alat(1,1)*alat(2,2)-alat(1,2)*alat(2,1))*div

      do iat=1,nat
      rxyzred(1,iat)=alatinv(1,1)*rxyz(1,iat)+alatinv(1,2)*rxyz(2,iat)+alatinv(1,3)*rxyz(3,iat)
      rxyzred(2,iat)=alatinv(2,1)*rxyz(1,iat)+alatinv(2,2)*rxyz(2,iat)+alatinv(2,3)*rxyz(3,iat)
      rxyzred(3,iat)=alatinv(3,1)*rxyz(1,iat)+alatinv(3,2)*rxyz(2,iat)+alatinv(3,3)*rxyz(3,iat)
      enddo

 end subroutine

     subroutine frac2cart(nat, alat, xyzred, rxyz)
!    Transforms from reduced to Cartesian coordinates
     implicit real*8 (a-h,o-z)
     dimension alat(3,3), xyzred(3,nat), rxyz(3,nat)
     
     do iat=1,nat
        do i = 1, 3
           t = 0.d0
           do j = 1, 3
              t = t + xyzred(j,iat) * alat(i, j)
           end do
           rxyz(i,iat) = t
        end do
     enddo

     end subroutine frac2cart



