import numpy as np
from ase.io import read, write
from ase.calculators.eam import EAM
from ase.md.velocitydistribution import MaxwellBoltzmannDistribution



def verlet_step(atoms, dt: float, forces: np.ndarray):
    # Get positions, velocites and masses
    velocities = atoms.get_velocities()
    positions = atoms.get_positions()
    
    # TODO: Update the positions
    new_positions = 0. #TODO
    atoms.set_positions(new_positions)
    
    # TODO: Calculate the new forces
    
    # TODO: update the velocites
    new_velocities = 0. #TODO
    atoms.set_velocities(new_velocities)
    
    return None


def elim_moment(velocities: np.ndarray):
    """
    Elimination of the momentum in the velocities
    """
    # eliminiation of momentum
    _s = np.sum(velocities, axis=0) / velocities.shape[0]
    no_moment_velocities = velocities - _s
    return no_moment_velocities



def main():
    # Read and create the structure
    # Read the file and create atoms object containing the positions and cell
    atoms = read('Na36.extxyz')
    # Create the EAM calculator to get energy and forces
    calculator = EAM(potential="Na_v2.eam.fs")
    # Attach the calculator to the atoms object
    atoms.calc = calculator


    # HOW TO GET (SET) THE POTENTIAL ENERGY, THE FORCES, VELOCITY WITH ASE:
    # positions = atoms.get_positions()
    # velocities = atoms.get_velocities()
    # potential_energy = atoms.get_potential_energy()
    # forces = atoms.get_forces()
    # 
    # atoms.set_positions(positions) 
    # atoms.set_velocities(velocities) 

    # Defining parameters
    dt = 0.05 # timestep for the md simulation
    nstep_equilibrium = 100 # number of equilibrium steps
    nstep = 4000 # number of steps to calculate the autocorrelation function
    temperature = 2000 # temperature of the md simulation
    
    # Create velocities according to the Maxell Boltzmann distribution
    MaxwellBoltzmannDistribution(atoms, temperature_K=temperature, communicator='serial')
    
    # Remove the momentum from the velocities
    velocities = atoms.get_velocities()
    velocities = elim_moment(velocities)
    atoms.set_velocities(velocities)

    # Run the equilibrium md
    write('md_equilibration.extxyz', atoms)
    forces = atoms.get_forces()
    for i in range(nstep_equilibrium):
        verlet_step(atoms, dt, forces)
        forces = atoms.get_forces()
        write('md_equilibration.extxyz', atoms, append=True)
        print('Equilibrium Step:  ', i)


    # Start calculating the velocity-velocity autocorrelation function
    velocities_zero = atoms.get_velocities()
    time = 0. 
    autocorrelation = 0.    

    # open file for the result
    f = open('autocorrelation.dat', 'w')
    write('md_run.extxyz', atoms)

    # md in which the autocorrelation is calculated
    forces = atoms.get_forces()
    for i in range(nstep):
        print('Autocorrelation Step:  ', i)
        verlet_step(atoms, dt, forces)
        forces = atoms.get_forces()
        write('md_run.extxyz', atoms, append=True)

        #TODO: Calculate the velocity-velocity autocorrelation function according to the exercise

        f.write(str(time) + '     ' + str(autocorrelation)+'\n')
    f.close()

if __name__ == '__main__':
    main()
