program VelcityVerlet
  IMPLICIT NONE
  DOUBLE PRECISION, PARAMETER :: dt=1.d-3                   !time step for velocity verlet
  DOUBLE PRECISION, PARAMETER :: rmass=1.d0                 !particle mass
  DOUBLE PRECISION, PARAMETER :: rkboltz=8.6173855d-5       !boltzmann constant
  DOUBLE PRECISION, PARAMETER :: temperature=1000           !temperature to play around and give the system sufficient
                                                            !kinetic energy
  DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:,:) :: rxyz     !particle position
  DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:,:) :: vxyz     !particle velocities
  DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:,:) :: vxyz0    !particle velocities when you start to calculate the
                                                            !autocorrelation
  DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:,:) :: fxyz     !forces of the particle at t
  DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:,:) :: gxyz     !old forces of the particle at t-1
  DOUBLE PRECISION :: alat(3)

  DOUBLE PRECISION :: t1, t2
  DOUBLE PRECISION :: autocorrelation                       !resulting value for the autocorrelation
  DOUBLE PRECISION :: coord, coord_var,count
  DOUBLE PRECISION :: ekinetic, ener_var, energy, energy0
  DOUBLE PRECISION :: pener, rkin, temp

  INTEGER :: nat,nstep,nsample
  INTEGER :: iat,j,istep,mplot,l

  CHARACTER(20) :: filename
  CHARACTER(3) :: fn

  open(unit=33,file='correlation.dat')
  open(unit=22,file='energies.dat',status='unknown')
  open(unit=11,file='Si_512.ascii')
  ! read alat,nat
  read(11,*) nat
  read(11,*) alat(1),t1,alat(2)
  read(11,*) t1, t2, alat(3)
  write(*,'(a,x,i7,3(x,e12.5))') 'nat,alat',nat,alat

  ! allocate arrays
  allocate(rxyz(3,nat),vxyz(3,nat),vxyz0(3,nat),fxyz(3,nat),gxyz(3,nat))

  ! read positions velocities
  do iat=1,nat
    read(11,*) (rxyz(j,iat),j=1,3)
  enddo
  close(1)

  !set velocities according to the maxwell distribution
  call gausdist(nat,vxyz)
  ekinetic = 1.5d0*rkboltz*temperature
  call velnorm(nat,ekinetic,vxyz)



! first forces: gxyz (these are the old forces step n)
  call bazant(nat,alat,rxyz,gxyz,pener,coord,ener_var,coord_var,count)


  nsample = 10000
  nstep=50000
  do istep=0,nstep
    !TODO: IMPLEMENT THE VELOCITY VERLET ALGORITHM
    !update all the positions according to the velocity verlet algorithm

    !calculate the new forces
    call bazant(nat,alat,rxyz,fxyz,pener,coord,ener_var,coord_var,count)
    
    !update the velocities of the particles 
    !calculate the kinetic energy 
    !and update the old force t-1

    ! TODO: IMPLEMENT THE TEMPERATURE
    ! instantaneous temperature calculated with the velocities

    if (istep.eq.nsample) then
      do iat=1,nat
        do l=1,3
          vxyz0(l,iat)=vxyz(l,iat)
        enddo
      enddo
    endif

    !TODO: CALCULATE THE VELOCITY-VELOCITY AUTOCORRELATION
    ! write the result of your calculation into the file 33 (correlation.dat)

    ! Lets denote by pener the potential energy, by rkin the kinetic energy 
    ! and by energy the total energy
    energy= pener+rkin
    if (istep.eq.0) energy0=energy
    energy= energy-energy0
    ! write energies and temperature every 100 timesteps 
    ! TODO: CHECK IN THE FILE ENERGY.DAT IF YOU OBSERVE ENERGY CONSERVATION
    if (mod(istep,100).eq.0)   & 
        write(22,'(i9,x,e17.10,2(x,e12.5),x,e11.4)')   istep,energy,pener,rkin,temp
        !write(22,'(i9,x,e17.10,2(x,e12.5),x,e11.4)')  istep,energy-energy0,rkin,energy-energy0+rkin 


    ! write the current atomic position after every mplot timesteps 
    ! into a visualization file
         if (mod(istep,mplot).eq. 1) then
          write(filename,'(a6,i6.6,a6)') 'posmd_',istep,'.ascii'
          open(unit=9,file=trim(filename))
          write(9,*) nat
          write(9,*) alat(1),0.,alat(2)
          write(9,*) 0.,0.,alat(3)
          do iat=1,nat
          write(9,*) (rxyz(l,iat),l=1,3),'  Si  '
          enddo
         endif

  enddo

1000    continue

  deallocate(rxyz,vxyz,vxyz0,fxyz,gxyz)
  close(22)
  close(33)


end program
