from ase.io import read
import numpy as np

#rxyz dimension => nat*3
#fxyz dimension => nat*x
def lenjon(rxyz):
    nat = rxyz.shape[0]
    fxyz = np.zeros((nat, 3))
    etot = 0.0

    for iat in range(nat):
        for jat in range(iat):
            dr = rxyz[iat, :] - rxyz[jat, :]
            dd = np.dot(dr, dr)
            dd2 = 1.E0 / dd
            dd6 = dd2**2 * dd2
            dd12 = dd2**6
            etot += 4.E0 * (dd12 - dd6)
            tt = 24.E0 * dd2 * (2.E0 * dd12 - dd6)
            ft = dr * tt
            fxyz[iat, :] = fxyz[iat, :] + ft
            fxyz[jat, :] = fxyz[jat, :] - ft

    return etot, fxyz

if __name__ == "__main__":
    # Read the atomic configuration from the "bcc.xyz" file
    atoms = read('./posinp.xyz')

    # Extract the number of atoms and their positions
    nat = len(atoms)
    rxyz = atoms.get_positions()  # Transposing to match the shape expected by the lenjon function

    # Calculate the total energy and forces using the lenjon function
    etot, fxyz = lenjon(rxyz)

    # Print the calculated total energy and forces
    print("Total Energy:", etot)
    print("Forces on each atom:")
    for i in range(15):
        print(fxyz[i,:])
